(function () {
    var container = document.getElementById("fireflies-container");
    if (!container) {
        container = document.createElement("div");
        container.id = "fireflies-container";
        container.style.position = "fixed";
        container.style.top = "0";
        container.style.left = "0";
        container.style.width = "100%";
        container.style.height = "100%";
        container.style.pointerEvents = "none";
        container.style.zIndex = "1";
        document.body.appendChild(container);
    } else {
        container.innerHTML = '';
    }

    var totalFireflies = 50;
    var containerWidth = window.innerWidth;
    var containerHeight = window.innerHeight;

    for (var i = 0; i < totalFireflies; i++) {
        var firefly = document.createElement("div");
        firefly.classList.add("firefly");
        container.appendChild(firefly);

        var size = Math.random() * 3 + 2;
        firefly.style.width = size + "px";
        firefly.style.height = size + "px";

        var startX = Math.random() * containerWidth;
        var startY = Math.random() * containerHeight;

        TweenMax.set(firefly, {
            x: startX,
            y: startY
        });

        var hue = Math.random() * 360;
        firefly.style.backgroundColor = 'hsla(' + hue + ', 100%, 85%, 0.8)';
        firefly.style.boxShadow = '0 0 6px hsla(' + hue + ', 100%, 50%, 0.4), 0 0 12px hsla(' + hue + ', 100%, 50%, 0.2)';

        animateFirefly(firefly, startX, startY);
    }

    function animateFirefly(element, anchorX, anchorY) {

        function float() {
            var radius = 25;
            var newX = anchorX + (Math.random() * radius * 2 - radius);
            var newY = anchorY + (Math.random() * radius * 2 - radius);

            var duration = Math.random() * 3 + 4;

            TweenMax.to(element, duration, {
                x: newX,
                y: newY,
                ease: Sine.easeInOut,
                onComplete: float
            });
        }

        float();

        TweenMax.to(element, Math.random() * 1.5 + 1.5, {
            opacity: Math.random() * 0.4 + 0.3,
            scale: Math.random() * 0.2 + 0.8,
            repeat: -1,
            yoyo: true,
            ease: Sine.easeInOut
        });
    }

    window.addEventListener('resize', function () {
        containerWidth = window.innerWidth;
        containerHeight = window.innerHeight;
    });
})();
